// File: content.js (v5.2 - Mode Pengulangan)
console.log("[DEBUG] content.js (v5.2 Mode Pengulangan) di-inject!");

// Variabel global untuk menyimpan ID timer pengulangan kita
let repeatTimerId = null;

// --- FUNGSI-FUNGSI UTAMA (Tidak Berubah) ---

function findNextButton() {
  const allButtons = document.querySelectorAll('button.sv-btn');
  for (const button of allButtons) {
    if (button.innerText.includes('Selanjutnya')) return button;
  }
  return null;
}

function fillCurrentPage() {
  // ... (Fungsi ini tetap sama persis seperti versi sebelumnya, tidak perlu disalin ulang jika tidak ada perubahan)
  console.log("[DEBUG] Memulai pengisian halaman saat ini...");
  const questionBlocks = document.querySelectorAll('div.sv_q');
  if (questionBlocks.length === 0) {
    console.warn("[DEBUG] Tidak ada pertanyaan ditemukan untuk diisi.");
    return false;
  }
  questionBlocks.forEach(block => {
    const matrixTable = block.querySelector('table.sv_q_matrix');
    const radioOptions = block.querySelectorAll('input[type="radio"]');
    const checkboxOptions = block.querySelectorAll('input[type="checkbox"]');
    if (matrixTable) {
      const rows = matrixTable.querySelectorAll('tbody tr');
      rows.forEach(row => {
        const rowRadios = row.querySelectorAll('input[type="radio"]');
        if (rowRadios.length > 0) {
          rowRadios[Math.floor(Math.random() * rowRadios.length)].click();
        }
      });
    } else if (radioOptions.length > 0) {
      radioOptions[Math.floor(Math.random() * radioOptions.length)].click();
    } else if (checkboxOptions.length > 0) {
      const allCheckboxes = Array.from(checkboxOptions);
      const numToSelect = Math.floor(Math.random() * allCheckboxes.length) + 1;
      allCheckboxes.sort(() => 0.5 - Math.random());
      for (let i = 0; i < numToSelect; i++) allCheckboxes[i].click();
    }
  });
  console.log(`[DEBUG] Pengisian ${questionBlocks.length} blok pertanyaan selesai.`);
  return true;
}


// --- FUNGSI BARU UNTUK AKSI BERULANG ---
function performRepeatingStep() {
    console.log("[ULANG] Menjalankan langkah pengulangan...");
    const pageFilled = fillCurrentPage();
    const nextBtn = findNextButton();

    if (pageFilled && nextBtn) {
        // Jika halaman berhasil diisi dan ada tombol next, klik
        nextBtn.click();
    } else {
        // Jika survei selesai atau ada error, hentikan pengulangan
        console.log("[ULANG] Kondisi berhenti terpenuhi. Menghentikan pengulangan.");
        clearInterval(repeatTimerId);
        repeatTimerId = null;
    }
}


// --- LOGIKA MODE SANGAT AGRESIF (Tidak Berubah) ---
let debounceTimer;
const observer = new MutationObserver((mutations, obs) => { /* ... (logika observer tetap sama) ... */ });
// ... (Semua logika MutationObserver dari versi sebelumnya tetap di sini)
const checkAndRunNext=()=>{console.log("[DEBOUNCE] Waktu jeda selesai. Memeriksa apakah halaman baru sudah siap...");chrome.storage.session.get("isSuperAggressive",e=>{e.isSuperAggressive?(console.log("[OBSERVER] Halaman baru terdeteksi & SIAP! Melanjutkan proses..."),observer.disconnect(),runAggressiveSequence()):(observer.disconnect(),console.log("[OBSERVER] Mode agresif nonaktif, observer berhenti."))})},handleMutation=(e,t)=>{clearTimeout(debounceTimer),debounceTimer=setTimeout(checkAndRunNext,750)};const newObserver=new MutationObserver(handleMutation);function runAggressiveSequence(){const e=fillCurrentPage();e?findNextButton()?(newObserver.observe(document.body,{childList:!0,subtree:!0}),console.log("[AGRESIF] Observer 'Sabar' diaktifkan. Mengklik 'Selanjutnya'..."),setTimeout(()=>findNextButton().click(),500)):(console.log("[AGRESIF] Proses selesai. Tombol 'Selanjutnya' tidak ditemukan."),chrome.storage.session.set({isSuperAggressive:!1}),newObserver.disconnect()):(console.log("[AGRESIF] Tidak ada pertanyaan, proses berhenti."),chrome.storage.session.set({isSuperAggressive:!1}))}


// --- LISTENER UTAMA (Diperbarui) ---

chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  console.log(`[DEBUG] Menerima pesan dari popup: ${request.action}`);
  
  switch (request.action) {
    case "fillStepOnly":
      // Hentikan mode berulang jika sedang berjalan
      if (repeatTimerId) clearInterval(repeatTimerId);
      fillCurrentPage();
      break;
      
    case "startRepeating":
      // Hentikan dulu jika sudah ada yang berjalan untuk menghindari dobel
      if (repeatTimerId) clearInterval(repeatTimerId);
      console.log("[ULANG] Memulai mode pengulangan setiap 0.3 detik.");
      // Jalankan sekali langsung, lalu atur pengulangan
      performRepeatingStep();
      repeatTimerId = setInterval(performRepeatingStep, 300); // 300 ms = 0.3 detik
      break;
      
    case "startSuperAggressive":
      // Hentikan mode berulang jika sedang berjalan
      if (repeatTimerId) clearInterval(repeatTimerId);
      runAggressiveSequence();
      break;

    case "stopAllActions":
      console.log("[STOP] Perintah berhenti diterima.");
      // Hentikan mode pengulangan
      if (repeatTimerId) {
        clearInterval(repeatTimerId);
        repeatTimerId = null;
        console.log("[STOP] Mode pengulangan telah dihentikan.");
      }
      // Hentikan mode super agresif (dengan menonaktifkan flag di storage)
      // Observer akan berhenti sendiri saat memeriksa flag ini di mutasi berikutnya
      chrome.storage.session.set({ isSuperAggressive: false });
      console.log("[STOP] Flag Super Agresif telah dinonaktifkan.");
      break;
  }
});